# Generated Python Strategy for: PlayerB (meta)
# Run Index: 7
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerB_DeepSeek_V3_MetaAgent_Run7_Iter1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Heuristic 1: Check for simple always-cooperate or always-defect strategies
    if "return 'C'" in opponent_program_code or "return 'C'" in opponent_program_code.replace(" ", ""):
        return "C"
    if "return 'D'" in opponent_program_code or "return 'D'" in opponent_program_code.replace(" ", ""):
        return "D"
    
    # Heuristic 2: Check for Tit-for-Tat-like strategies (common patterns)
    tit_for_tat_patterns = [
        "opp_history[-1]",
        "return opp_history[-1]",
        "if len(opp_history) > 0: return opp_history[-1]"
    ]
    for pattern in tit_for_tat_patterns:
        if pattern in opponent_program_code:
            return "C" if len(opp_history) == 0 else opp_history[-1]
    
    # Heuristic 3: Check for code length (very short code might be simple strategies)
    lines = opponent_program_code.splitlines()
    non_empty_lines = [line.strip() for line in lines if line.strip()]
    if len(non_empty_lines) <= 3:
        return "C"  # Assume simple cooperator
    
    # Heuristic 4: Check for presence of 'random' (might be unpredictable)
    if "random" in opponent_program_code:
        return "D" if len(opp_history) > 10 and sum(1 for move in opp_history if move == 'D') > 5 else "C"
    
    # Heuristic 5: Check for self-referential code (similarity to our own logic)
    self_referential_keywords = [
        "opponent_program_code",
        "heuristic",
        "len(opp_history)",
        "len(my_history)"
    ]
    similar_keywords = sum(1 for keyword in self_referential_keywords if keyword in opponent_program_code)
    if similar_keywords >= 2:
        return "C"
    
    # Fallback: Tit-for-Tat with initial cooperation
    if len(opp_history) == 0:
        return "C"
    return opp_history[-1]